@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'thor-webinar-link' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'thor-'.$block['slug'];

  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $webinars = get_field('webinar');
 
@endphp

<div id="{!! esc_attr($id) !!}" class="{!! esc_attr($className); !!}">
  @foreach ($webinars as $webinar)
    <a class="webinar-wrapper" href="{!! $webinar['webinar_link']['url'] !!}" target="{!! $webinar['webinar_link']['target'] !!}">
      <div class="content-wrapper">
        <time class="time">{!! $webinar['webinar_date'] !!}</time>
        <h5 class="link-title">{!! $webinar['webinar_link']['title'] !!}</h5>
        <p class="description">{!! $webinar['webinar_description'] !!}</p>
      </div>

      @svg('images/square-arrow.svg')
    </a>
  @endforeach
</div>