@php
  $link_find_out_more = get_field('link_find_out_more', get_the_ID());

  $args_related_products = [
    'post_type' => 'products',
    'post_status' => 'publish',
    'posts_per_page' => 3,
    'meta_query' => [
      [
        'key'   => 'product_relation_with_company',
        'value' => get_post()->ID,
        'compare' => 'LIKE',
      ],
    ],
  ];
  $related_products = get_posts($args_related_products);

  $args_related_posts = [
    'post_type' => 'post',
    'post_status' => 'publish',
    'posts_per_page' => 3,
    'meta_query' => [
      [
        'key'   => 'post_relation_with_companies',
        'value' => get_post()->ID,
        'compare' => 'LIKE',
      ],
    ],
  ];
  $related_posts = get_posts($args_related_posts);

  $maps = get_field('company_address');
  $address_contacts = get_field('address_contacts');
  $website_url = get_field('website_url');
  $store_locator_url = get_field('store_locator_url');
  $price_request_url = get_field('price_request_url');
  $catalog_request_url = get_field('catalog_request_url');
  $email_for_form = get_field('email_for_form');
  $terms_company = get_the_terms( $last_post->ID, 'category_companies' );
  $post_type = get_post_type( get_the_ID() );
  $archive_link = get_post_type_archive_link($post_type);
@endphp

<article {!! post_class('single-post-wrapper') !!}>

  <div class="wrapper-back-to-archive">
    <a href="{{ $archive_link }}" class="back-to-archive">
      {!! __('Torna alle aziende', 'thor') !!}
      @svg('images/arrow-teaser-archive.svg')
    </a>
  </div>
  @include('partials/page-header')

  <div class="container">

    <div class="single-post-inner clearfix">
      <div class="post-content-wrapper">
        <div class="left-content-wrapper">
          <div class="header">
            <div class="main-image">
              <figure>
                <img
                  class="lazy"
                  src="{!! get_the_post_thumbnail_url(get_the_ID(), 'thumbnail') !!}"

                  data-src="{!! get_the_post_thumbnail_url(get_the_ID(), 'large') !!}"

                />
              </figure>
            </div>

            <div class="title">
              <h1>{!! App::title() !!}</h1>
              <div class="category-wrapper">
                @if ($terms_company)
                  @foreach ($terms_company as $term)
                    <span class="post-badge">{!! $term->name !!}</span>
                  @endforeach
                @endif
              </div>
            </div>
          </div>

          <div class="left-side-wrapper">
            <div class="left-side">
              @if ($maps)
                <div class="maps-iframe">
                  {!! $maps !!}
                </div>
              @endif

              <div class="company-info">
                @if ($address_contacts)
                  <div class="address-contacts">
                    {!! $address_contacts !!}
                  </div>
                @endif

                @if ($website_url)
                  <a href="{!! $website_url['url'] !!}" target="{!! $website_url['target'] !!}" class="company-website">{!! $website_url['title'] !!}</a>
                @endif
              </div>

              <div class="external-buttons">
                @if ($store_locator_url)
                  <a href="{!! $store_locator_url !!}" target="blank" class="store-locator">
                    {!! __('Trova rivenditore', 'thor') !!}
                  </a>
                @endif

                @if ($price_request_url)
                  <a href="{!! $price_request_url !!}" target="blank" class="price-request">
                    {!! __('Richiedi prezzi', 'thor') !!}
                  </a>
                @endif

                @if ($catalog_request_url)
                  <a href="{!! $catalog_request_url !!}" target="blank" class="catalog-request">
                    {!! __('Richiedi catalogo', 'thor') !!}
                  </a>
                @endif
              </div>

              <div class="share">
                <h5>
                  {!! __('Condividi', 'thor') !!}
                </h5>
                <social-sharing-link
                  url="{!! esc_attr(get_the_permalink()) !!}"
                />
              </div><!--share-->
            </div>


            <div class="content">
              @php the_content() @endphp
            </div>

            <div class="share mobile">
              <h5>
                {!! __('Condividi', 'thor') !!}
              </h5>
              <social-sharing-link
                url="{!! esc_attr(get_the_permalink()) !!}"
              />
            </div><!--share-->
          </div>
        </div>
      </div>

      <div class="form">
        <div class="section-divider"></div>
        <h3 class="title-section"> {!! __('Richiedi informazioni a', 'thor') !!} {!! App::title() !!}</h3>
        @php
          $parmas = [
            'company_name' => get_the_title(),
            'company_email' => $email_for_form,
          ];
          gravity_form( 1, false, false, false, $parmas, false );
        @endphp
      </div>

      @if ($related_posts)
        <div class="teaser-wrapper">
            <div class="section-divider"></div>
            <h3 class="title-section">{!! __('News di', 'thor') !!} {!! App::title() !!}</h3>
            <div class="teaser">
              @foreach ($related_posts as $post)
                @php
                  $post_badge = get_field('lioit_post_badge_text', $post->ID);
                  $term = get_the_terms( $post->ID, 'category' );
                @endphp
                <article class="post-teaser">
                  <span class="post-badge">
                    @if ($post_badge)
                        {!! $post_badge !!}
                    @else
                      {!! $term[0]->name !!}
                    @endif
                    <time
                      class="updated mobile"
                      datetime="{{ get_post_time('d F o', true) }}">
                      {{ get_the_date('d F o', $featured->ID) }}
                    </time>
                  </span>

                  <div class="content-wrapper">
                    <div class="content-left">
                      @if (has_post_thumbnail($post->ID))
                        <figure>
                          <a href="{{ get_permalink($post->ID) }}" title="{!! get_the_title($post->ID) !!}">
                            <img
                              class="lazy"
                              src="{!! get_the_post_thumbnail_url($post->ID, 'mini') !!}"
                              data-src="{!! get_the_post_thumbnail_url($post->ID, 'large') !!}"
                            />
                          </a>
                        </figure>
                      @endif
                    </div>

                    <div class="content-right">
                      <header>
                        <a href="{{ get_permalink($post->ID) }}" title="{!! get_the_title($post->ID) !!}">
                          <h2>
                            {!! get_the_title($post->ID) !!}
                          </h2>
                        </a>
                      </header>

                      <time
                        class="updated"
                        datetime="{{ get_post_time('d F o', true) }}">
                        {{ get_the_date('d F o', $post->ID) }}
                      </time>
                    </div>
                  </div>

                </article>
              @endforeach
            </div>
        </div>
      @endif

      @if ($related_products)
        <div class="teaser-wrapper">
            <div class="section-divider"></div>
            <h3 class="title-section">{!! __('Prodotti di', 'thor') !!} {!! App::title() !!}</h3>
            <div class="teaser">
              @foreach ($related_products as $product)
                @php
                  $post_badge = get_field('lioit_post_badge_text', $post->ID);
                  $term = get_the_terms( $post->ID, 'category' );
                @endphp
                <article class="post-teaser">
                  <span class="post-badge">
                    @if ($post_badge)
                        {!! $post_badge !!}
                    @else
                      {!! $term[0]->name !!}
                    @endif
                    <time
                      class="updated mobile"
                      datetime="{{ get_post_time('d F o', true) }}">
                      {{ get_the_date('d F o', $featured->ID) }}
                    </time>
                  </span>

                  <div class="content-wrapper">
                    <div class="content-left">
                      @if (has_post_thumbnail($product->ID))
                        <figure>
                          <a href="{{ get_permalink($product->ID) }}" title="{!! get_the_title($product->ID) !!}">
                            <img
                              class="lazy"
                              src="{!! get_the_post_thumbnail_url($product->ID, 'mini') !!}"
                              data-src="{!! get_the_post_thumbnail_url($product->ID, 'large') !!}"
                            />
                          </a>
                        </figure>
                      @endif
                    </div>

                    <div class="content-right">
                      <header>
                        <a href="{{ get_permalink($product->ID) }}" title="{!! get_the_title($product->ID) !!}">
                          <h2>
                            {!! get_the_title($product->ID) !!}
                          </h2>
                        </a>
                      </header>

                      <time
                        class="updated"
                        datetime="{{ get_post_time('d F o', true) }}">
                        {{ get_the_date('d F o', $product->ID) }}
                      </time>
                    </div>
                  </div>

                </article>
              @endforeach
            </div>
        </div>
      @endif
    </div><!--single-post-inner-->
  </div><!--container-->
</article>
