@php
  $banner_leaderboard = get_field('banner_leaderboard', 'option');
  $skin_mobile = get_field('skin_mobile', 'option');
  $skin_reveal = get_field('skin_reveal', 'option');
  $banner_leaderboard_5 = get_field('banner_leaderboard_5', 'option');
  $theme_color_primary = get_field('theme_color_primary', 'option') ? get_field('theme_color_primary', 'option') : '#ffcc00';
@endphp
<!doctype html>
<html {!! get_language_attributes() !!}>
  <style>
    :root {
      --theme-color-primary: {{ $theme_color_primary }};
    }
  </style>
  @include('partials.head')
  <body @php body_class() @endphp>
    @php
      do_action('in_body');
    @endphp
    <main id="app" class="page-wrapper">
      @php do_action('get_header') @endphp
      
      @include('partials.header')
      @include('partials.ticker')
      @include('partials.skin-adv')

      <div class="wrap" role="document" id="main-container">
        <div class="content">
          <main class="main">
            @if ($banner_leaderboard)
              <div class="banner-leaderboard">{!! $banner_leaderboard !!}</div>
            @endif
            @if ($skin_reveal)
              <div class="skin-reveal">{!! $skin_reveal !!}</div>
            @endif
            @if ($skin_mobile)
              <div class="skin-mobile">{!! $skin_mobile !!}</div>
            @endif
            @yield('content')
          </main>
          @if (App\display_sidebar())
            <aside class="sidebar">
              @include('partials.sidebar')
            </aside>
          @endif
        </div>

        @if ($banner_leaderboard_5)
          <div class="prefooter">
            <div class="banner-leaderboard-5">{!! $banner_leaderboard_5 !!}</div>
          </div>
        @endif
      </div>

      @php do_action('get_footer') @endphp
      @include('partials.footer')
      @include('partials.overlay-menu')
    </main>
    @php wp_footer() @endphp
  </body>
</html>