@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'thor-posts-home' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'thor-'.$block['slug'];

  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $category_teaser = get_field('category_teaser');
  $section_title = get_field('section_title');
  $show_box_adv = get_field('show_box_adv');
  $show_halfpage_adv = get_field('show_halfpage_adv');
  $category_filter = get_field('category_filter');
  $tag_filter = get_field('tag_filter');
  $layout_grid = get_field('layout_grid');

  $last_posts_category = [
  'post_status' => 'publish',
  'posts_per_page' => 4,
  'orderby' => 'date',
  'category_name' => $category_filter->slug ? $category_filter->slug : '',
  'tag' => $tag_filter ? $tag_filter->slug : '',
  ];
  $last_posts_category = get_posts($last_posts_category);

  $category_archive_link = get_term_link( $category_filter->term_id );
@endphp

<div id="{!! esc_attr($id) !!}" class="{!! esc_attr($className); !!}">

  <div class="content-wrapper">
    <div class="teaser-posts @if(!$layout_grid)no-grid @endif">
      <div class="section-header">
        <div class="section-divider"></div>
        <div class="flex justify-between">
          <h3 class="section-title">{!! $section_title !!}</h3>
          <a class="link-archive" href="{{ $category_archive_link }}">
             {!! __('Vedi tutte', 'thor') !!}
            @svg('images/arrow-right-archive.svg')
          </a>
        </div>
      </div>

      @if ($layout_grid)
        <div class="article-wrapper">
          <div class="article-big">
            @if ($last_posts_category)
              @foreach ($last_posts_category as $last_post)
                @include('partials.teaser-posts-category')
              @endforeach
            @endif
          </div>

          <div class="article-small">
            @if ($last_posts_category)
              @foreach ($last_posts_category as $last_post)
                @include('partials.teaser-posts-category')
              @endforeach
            @endif
          </div>

          <div class="link-wrapper">
            <a class="link-archive" href="{{ $category_archive_link }}">
               {!! __('Vedi tutte', 'thor') !!}
              @svg('images/arrow-right-archive.svg')
            </a>
          </div>
        </div>
      @endif

      @if (!$layout_grid)
        <div class="section-technical-questions">
          <div class="teaser-wrapper">
            @foreach ($last_posts_category as $last_post)
              @php
                $post_badge = get_field('lioit_post_badge_text', $last_post->ID);
                $term = get_the_terms( $last_post->ID, 'category' );
              @endphp
              <article class="post-teaser">
                <span class="post-badge">
                  @if ($post_badge)
                    {!! $post_badge !!}
                  @else
                    {!! $term[0]->name !!}
                  @endif
                  <time
                    class="updated mobile"
                    datetime="{{ get_post_time('d F o', true) }}">
                    {{ get_the_date('d F o', $last_post->ID) }}
                  </time>
                </span>
                <header>
                  <a href="{{ get_permalink($last_post->ID) }}" title="{!! get_the_title($last_post->ID) !!}">
                    <h2>
                      {!! get_the_title($last_post->ID) !!}
                      @svg('images/arrow-right-up.svg')
                    </h2>
                  </a>
                </header>
                <time
                  class="updated"
                  datetime="{{ get_post_time('d F o', true) }}">
                  {{ get_the_date('d F o', $last_post->ID) }}
                </time>
                <div class="entry-summary">
                  {!! get_the_excerpt($last_post->ID); !!}
                </div>
              </article>
            @endforeach
          </div>
        </div>
      @endif
    </div>

    @if ($show_box_adv || $show_halfpage_adv)
      <div class="adv-wrapper">
        @if ($show_box_adv)
          @include('partials.adv-box-1')
          @include('partials.adv-box-2')
          @include('partials.adv-box-3')
        @endif

        @if ($show_halfpage_adv)
          @include('partials.adv-halfpage')
        @endif
      </div>
    @endif
  </div>
</div>