<?php
namespace App;

function thor_blocks_callback($block, $content = '', $is_preview = false, $post_id = 0 ) {
  $slug = str_replace('acf/', '', $block['name']);
  $block['slug'] = $slug;
  $block['classes'] = implode(' ', [$block['slug'], $block['className'], 'align'.$block['align']]);
  $template = null;
  $data = collect(get_body_class())->reduce(function ($data, $class) use ($template) {
    return apply_filters("sage/template/{$class}/data", $data, $template);
    }, []);
    
  $data['block'] = $block;
  $data['content'] = $content;
  $data['is_preview'] = $is_preview;
  $data['post_id'] = $post_id;
  echo \App\template("blocks/${slug}", $data);
}
// Register custom blocks
if( function_exists('acf_register_block_type') ) {

  add_action('init', function () {
    acf_register_block_type(array(
      'name'              => 'slider',
      'title'             => __('Slider', 'thor'),
      'description'       => __('Slider of images', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => 'slides',
      'keywords'          => array( 'slider', 'image', 'custom' ),
      'supports'          => array(
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'posts_list',
      'title'             => __('Posts List', 'thor'),
      'description'       => __('Select posts to show', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => 'list-view',
      'keywords'          => array('posts', 'image', 'custom'),
      'supports'          => array(
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'webinar_link',
      'title'             => __('Webinar Link', 'thor'),
      'description'       => __('Select posts to show', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => 'list-view',
      'keywords'          => array('webinar', 'link', 'custom'),
      'supports'          => array(
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'posts_slider',
      'title'             => __('Posts Slider', 'thor'),
      'description'       => __('Select posts to show in slider', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => 'editor-insertmore',
      'keywords'          => array('posts', 'slider', 'custom'),
      'mode'	            => 'false',
      'supports'          => array(
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'posts_home',
      'title'             => __('Posts Home', 'thor'),
      'description'       => __('Select posts to show teaser', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => 'editor-insertmore',
      'keywords'          => array('posts', 'teaser', 'custom'),
      'mode'	            => 'false',
      'supports'          => array(
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'posts_feautured',
      'title'             => __('Posts Featured', 'thor'),
      'description'       => __('Select posts to show teaser', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => 'editor-insertmore',
      'keywords'          => array('posts', 'teaser', 'custom'),
      'mode'	            => 'false',
      'supports'          => array(
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'posts_feautured_slider',
      'title'             => __('Posts Featured Slider', 'thor'),
      'description'       => __('Select posts to show teaser', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => 'editor-insertmore',
      'keywords'          => array('posts', 'teaser', 'custom'),
      'mode'	            => 'false',
      'supports'          => array(
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'accordion',
      'title'             => __('Accordion', 'thor'),
      'description'       => __('Accordion', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => 'editor-insertmore',
      'keywords'          => array('slider', 'image', 'custom'),
      'supports'          => array(
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
        'mode' => false,
        '__experimental_jsx' => true,
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'map',
      'title'             => __('Map', 'thor'),
      'description'       => __('Group of Google Maps', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => 'location-alt',
      'keywords'          => array( 'map', 'google', 'contact', 'location', 'geo' ),
      'enqueue_assets'    => function () {
        wp_enqueue_script('gmaps-api');
      },
      'supports'          => array(
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

  }, 10);
}