<?php

namespace App\Controllers;

use Sober\Controller\Controller;

class App extends Controller
{
    public function siteName()
    {
        return get_bloginfo('name');
    }

    public static function title()
    {
        if (is_home()) {
            if ($home = get_option('page_for_posts', true)) {
                return get_the_title($home);
            }
            return __('Latest Posts', 'thor');
        }
        if (is_archive()) {
            return get_the_archive_title();
        }
        if (is_search()) {
            return sprintf(__('Search Results for %s', 'thor'), get_search_query());
        }
        if (is_404()) {
            return __('Not Found', 'thor');
        }
        return get_the_title();
    }

    public static function socialbar()
    {
        if(function_exists('get_field'))
        {
            $html = '<div class="socialbar-container"><div class="socialbar">';
if (get_field('facebook', 'option')) {
    $html .= '<a href="' . esc_url(get_field('facebook', 'option')) . '" target="_blank" title="' . __('Facebook', 'thor') . '" class="facebook"><svg width="7" height="14" viewBox="0 0 7 14" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M5.82393 6.57829H4.02393V13.1723H1.29695V6.57829H0V4.26019H1.29695V2.76071C1.29695 1.68853 1.80607 0.00878906 4.04865 0.00878906L6.06803 0.0177801V2.26711H4.6025C4.36199 2.26711 4.02393 2.38736 4.02393 2.8985V4.26288H6.06264L5.82393 6.57829Z" fill="#FFCC00"/>
</svg></a>';
}
if (get_field('twitter', 'option')) {
    $html .= '<a href="' . esc_url(get_field('twitter', 'option')) . '" target="_blank" title="' . __('Twitter', 'thor') . '" class="twitter">
               <svg width="17" height="14" viewBox="0 0 17 14" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M16.6248 1.80198C16.0308 2.06531 15.3911 2.24395 14.721 2.32368C15.4056 1.91294 15.9307 1.26359 16.1795 0.489687C15.5382 0.868911 14.8286 1.14522 14.0738 1.29388C13.469 0.649165 12.607 0.24707 11.6532 0.24707C9.82168 0.24707 8.33817 1.73213 8.33817 3.56211C8.33817 3.82173 8.36691 4.07547 8.42378 4.31809C5.66877 4.17932 3.22529 2.8596 1.59064 0.853149C1.30445 1.34333 1.14157 1.91294 1.14157 2.52025C1.14157 3.6709 1.72694 4.68618 2.6155 5.28021C2.07217 5.26321 1.56159 5.11362 1.11375 4.86482V4.90717C1.11375 6.51276 2.25699 7.85287 3.77326 8.1573C3.49572 8.23364 3.20242 8.27444 2.90046 8.27444C2.6869 8.27444 2.47921 8.25373 2.27615 8.2151C2.69895 9.53234 3.92316 10.4908 5.37423 10.5173C4.23934 11.4071 2.80991 11.9359 1.25623 11.9359C0.987962 11.9359 0.723711 11.9214 0.465332 11.8902C1.93216 12.831 3.67436 13.3799 5.54668 13.3799C11.6449 13.3799 14.9806 8.32729 14.9806 3.94628C14.9806 3.80256 14.9769 3.66009 14.9707 3.51761C15.6191 3.0503 16.1807 2.46616 16.6248 1.80198Z" fill="#FFCC00"/>
</svg>
             </a>';
}
if (get_field('whatsapp', 'option')) {
    $html .= '<div><a href="https://api.whatsapp.com/send?phone=' . get_field('whatsapp', 'option') . '" target="_blank" title="' . __('Whatsapp', 'thor') . '" class="whatsapp">
               <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><!--! Font Awesome Pro 6.1.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2022 Fonticons, Inc. --><path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7.9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"/></svg>
             </a></div>';
}
if (get_field('youtube', 'option')) {
    $html .= '<a href="' . esc_url(get_field('youtube', 'option')) . '" target="_blank" title="' . __('YouTube', 'thor') . '" class="youtube">
               <svg width="20" height="14" viewBox="0 0 20 14" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M19.2555 11.3388C19.6502 9.83856 19.6502 6.72735 19.6502 6.72735C19.6502 6.72735 19.6662 3.60068 19.2555 2.10045C19.0344 1.27929 18.3869 0.631554 17.5657 0.410609C16.0655 0 10.0645 0 10.0645 0C10.0645 0 4.06349 0 2.56326 0.394909C1.7578 0.615854 1.09437 1.27929 0.873424 2.10045C0.478516 3.60068 0.478516 6.71165 0.478516 6.71165C0.478516 6.71165 0.478516 9.83856 0.873424 11.3229C1.09461 12.1441 1.7421 12.7917 2.56326 13.0127C4.07919 13.4233 10.0645 13.4233 10.0645 13.4233C10.0645 13.4233 16.0655 13.4233 17.5657 13.0284C18.3869 12.8074 19.0344 12.1599 19.2555 11.3388ZM13.1439 6.71149L8.15369 9.58557V3.8374L13.1439 6.71149Z" fill="#FFCC00"/>
</svg>
             </a>';
}
if (get_field('vimeo', 'option')) {
    $html .= '<a href="' . esc_url(get_field('vimeo', 'option')) . '" target="_blank" title="' . __('Vimeo', 'thor') . '" class="vimeo">
               <object data="' . get_theme_file_uri() . '/dist/images/social/svg/vimeo.svg" type="image/svg+xml">
               </object>
             </a>';
}
if (get_field('linkedin', 'option')) {
    $html .= '<a href="' . esc_url(get_field('linkedin', 'option')) . '" target="_blank" title="' . __('LinkedIn', 'thor') . '" class="linkedin">
               <svg width="13" height="13" viewBox="0 0 13 13" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_21_2609)">
<path d="M12.0403 0H0.959653C0.705137 0 0.461046 0.101106 0.281076 0.281076C0.101106 0.461046 0 0.705137 0 0.959653V12.0403C0 12.2949 0.101106 12.539 0.281076 12.7189C0.461046 12.8989 0.705137 13 0.959653 13H12.0403C12.2949 13 12.539 12.8989 12.7189 12.7189C12.8989 12.539 13 12.2949 13 12.0403V0.959653C13 0.705137 12.8989 0.461046 12.7189 0.281076C12.539 0.101106 12.2949 0 12.0403 0ZM3.87472 11.0744H1.92021V4.86597H3.87472V11.0744ZM2.89611 4.00563C2.67441 4.00438 2.45804 3.93748 2.27431 3.81338C2.09059 3.68928 1.94775 3.51354 1.86381 3.30833C1.77987 3.10313 1.7586 2.87765 1.80268 2.66037C1.84677 2.44309 1.95423 2.24373 2.1115 2.08747C2.26878 1.9312 2.46882 1.82502 2.68638 1.78233C2.90394 1.73965 3.12927 1.76236 3.33393 1.84762C3.5386 1.93287 3.71342 2.07684 3.83634 2.26136C3.95925 2.44587 4.02476 2.66267 4.02458 2.88438C4.02667 3.03281 3.99886 3.18015 3.9428 3.3176C3.88674 3.45506 3.80357 3.57982 3.69827 3.68445C3.59296 3.78908 3.46767 3.87144 3.32985 3.92662C3.19204 3.9818 3.04453 4.00867 2.89611 4.00563ZM11.0789 11.0798H9.12528V7.68806C9.12528 6.68778 8.70007 6.37903 8.15118 6.37903C7.5716 6.37903 7.00285 6.81597 7.00285 7.71333V11.0798H5.04833V4.87049H6.92792V5.73083H6.9532C7.14188 5.34896 7.80271 4.69625 8.81111 4.69625C9.90167 4.69625 11.0798 5.34354 11.0798 7.23938L11.0789 11.0798Z" fill="#3D3D3C"/>
</g>
<defs>
<clipPath id="clip0_21_2609">
<rect width="13" height="13" fill="white"/>
</clipPath>
</defs>
</svg>
             </a>';
}
if (get_field('instagram', 'option')) {
    $html .= '<a href="' . esc_url(get_field('instagram', 'option')) . '" target="_blank" title="' . __('Instagram', 'thor') . '" class="instagram">
               <?xml version="1.0" encoding="iso-8859-1"?>
<!-- Generator: Adobe Illustrator 19.0.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->
<svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
<g>
	<g>
		<path d="M352,0H160C71.648,0,0,71.648,0,160v192c0,88.352,71.648,160,160,160h192c88.352,0,160-71.648,160-160V160
			C512,71.648,440.352,0,352,0z M464,352c0,61.76-50.24,112-112,112H160c-61.76,0-112-50.24-112-112V160C48,98.24,98.24,48,160,48
			h192c61.76,0,112,50.24,112,112V352z"/>
	</g>
</g>
<g>
	<g>
		<path d="M256,128c-70.688,0-128,57.312-128,128s57.312,128,128,128s128-57.312,128-128S326.688,128,256,128z M256,336
			c-44.096,0-80-35.904-80-80c0-44.128,35.904-80,80-80s80,35.872,80,80C336,300.096,300.096,336,256,336z"/>
	</g>
</g>
<g>
	<g>
		<circle cx="393.6" cy="118.4" r="17.056"/>
	</g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
</svg>

             </a>';
}
if (get_field('pinterest', 'option')) {
    $html .= '<a href="' . esc_url(get_field('pinterest', 'option')) . '" target="_blank" title="' . __('Pinterest', 'thor') . '" class="pinterest">
               <object data="' . get_theme_file_uri() . '/dist/images/social/svg/pinterest.svg" type="image/svg+xml">
               </object>
             </a>';
}
if (get_field('flickr', 'option')) {
    $html .= '<a href="' . esc_url(get_field('flickr', 'option')) . '" target="_blank" title="' . __('Flickr', 'thor') . '" class="flickr">
               <object data="' . get_theme_file_uri() . '/dist/images/social/svg/flickr.svg" type="image/svg+xml">
               </object>
             </a>';
}
$html .= '</div></div>';


        return $html;
        }
    }

    public function credits()
    {
        return __('Designed and developed by <a href="https://dueper.net" target="_blank">Dueper Design</a>', 'thor');
    }
}
