@php
  $theme_logo_single_color = get_field('theme_logo_single_color', 'option');
@endphp
<div id="overlay-menu">
  <div class="overlay-menu-inner">
    <div class="overlay-header">
      <a class="brand" href="{{ home_url('/') }}">
        <img src="{!! $theme_logo_single_color['url'] !!}" alt="">
      </a>

      <figure class="close-overlay-1">
        @svg('images/close-overlay-1-yellow.svg')
      </figure>
    </div>

    <form action="/" method="get" class="search-form">
      <div class="content-wrapper">
        <input type="text" name="s" id="search" placeholder=" {!! __('Cerca', 'thor') !!}" autocomplete="off" value="<?php the_search_query(); ?>" />

        <button class="button-search">
          @svg('images/search-yellow.svg')
        </button>
      </div>
    </form>

    <nav class="nav-primary">
      @if (has_nav_menu('overlay_navigation'))
        {!! wp_nav_menu(['theme_location' => 'overlay_navigation', 'menu_class' => 'nav']) !!}
      @endif
    </nav>

    <nav class="nav-primary submenu-overlay">
      @if (has_nav_menu('overlay_submenu'))
        {!! wp_nav_menu(['theme_location' => 'overlay_submenu', 'menu_class' => 'nav', 'depth' => 1]) !!}
      @endif
    </nav>

    {!! App::socialbar() !!}
  </div>
</div>

<div id="overlay-menu-2">
  <div class="overlay-menu-inner">
    <div class="overlay-header">
      <figure class="arrow-back-overlay-2">
        @svg('images/arrow-back-overlay-2.svg')
      </figure>
      <h2 class="overlay-2-title"></h2>
      <figure class="close-overlay-2">
        @svg('images/close-overlay-2.svg')
      </figure>
    </div>

    <nav class="nav-primary nav-overlay-2">
      @if (has_nav_menu('overlay_navigation'))
        {!! wp_nav_menu(['theme_location' => 'overlay_navigation', 'menu_class' => 'nav'],) !!}
      @endif
    </nav>
  </div>
</div>