@php
  $teaser_gallery = get_field('images_gallery', get_the_ID());
  $count_image_gallery = count($teaser_gallery);
  $number_image_gallery = $count_image_gallery - 1;
  $summary_teaser = get_field('summary_teaser', get_the_ID());
@endphp

<article class="technical-event-teaser">
  <div class="content-top">
    <div class="media-teaser">
      @if (has_post_thumbnail())
        <figure class="thumbnail">
          <a href="{{ get_permalink() }}" title="{!! get_the_title() !!}">
            <img
              class="lazy"
              src="{!! get_the_post_thumbnail_url() !!}"
              data-src="{!! get_the_post_thumbnail_url() !!}"
            />
          </a>
        </figure>
      @endif

      <div class="teaser-gallery">
        <a href="{{ get_permalink() }}" title="{!! get_the_title() !!}">
          <figure>
            <img src="{!! $teaser_gallery[0]['url'] !!}" alt="">
            <div class="overlay"></div>
          </figure>
        </a>

        @if ($count_image_gallery > 1)
          <a href="{{ get_permalink() }}" title="{!! get_the_title() !!}">
            <figure>
              <img src="{!! $teaser_gallery[1]['url'] !!}" alt="">
              @if ($count_image_gallery > 2)
                <div class="gallery-counter">
                  <span>
                    +{!! $number_image_gallery !!}
                  </span>
                </div>
              @endif
            </figure>
          </a>
        @endif
      </div>
    </div>
  </div>
  
  <div class="content-bottom">
    <header>
      <a href="{{ get_permalink() }}" title="{!! get_the_title() !!}">
        <h2>
          {!! get_the_title() !!}
        </h2>
      </a>

      <a href="{{ get_permalink() }}" title="{!! get_the_title() !!}" class="teaser-arrow mobile">
        @svg('images/arrow-teaser-archive.svg')
      </a>
    </header>

    <div class="right">
      @if ($summary_teaser)
        <div class="summary-teaser">
          {!! $summary_teaser !!}
        </div>
      @endif
      <a href="{{ get_permalink() }}" title="{!! get_the_title() !!}" class="teaser-arrow">
        @svg('images/arrow-teaser-archive.svg')
      </a>
    </div>
  </div>
</article>