@php
  $post_badge = get_field('lioit_post_badge_text', $last_post->ID);
  $term = get_the_terms(  $last_post->ID, 'category' );
  $terms_company = get_the_terms( $last_post->ID, 'category_companies' );
  $terms_products = get_the_terms( $last_post->ID, 'category_products' );
  $is_archive_products = is_post_type_archive( 'products' );
  $is_archive_companies = is_post_type_archive( 'companies' );
@endphp

<article class="post-teaser @if($company) company @endif">
  <span class="post-badge mobile">
    @if ($post_badge)
      {!! $post_badge !!}
    @else
      {!! $term[0]->name !!}
    @endif
    <time
      class="updated mobile"
      datetime="{{ get_post_time('d F o', true) }}">
      {{ get_the_date('d F o', $featured->ID) }}
    </time>
  </span>

  <div class="content-wrapper">
    <div class="content-left">
      <span class="post-badge desktop">
        @if ($post_badge)
          {!! $post_badge !!}
        @else
        {!! $term[0]->name !!}
        @endif
      </span>
      @if (has_post_thumbnail($last_post->ID))
        <figure>
          <a href="{{ get_permalink($last_post->ID) }}" title="{!! get_the_title($last_post->ID) !!}">
            <img
              class="lazy"
              src="{!! get_the_post_thumbnail_url($last_post->ID, 'mini') !!}"
              data-src="{!! get_the_post_thumbnail_url($last_post->ID, 'large') !!}"
            />
          </a>
        </figure>
      @endif
    </div>
    
    <div class="content-right">
      <header>
        <a href="{{ get_permalink($last_post->ID) }}" title="{!! get_the_title($last_post->ID) !!}">
          <h2>
            {!! get_the_title($last_post->ID) !!}
          </h2>
        </a>
      </header>
      <time
        class="updated"
        datetime="{{ get_post_time('d F o', true) }}">
        {{ get_the_date('d F o', $last_post->ID) }}
      </time>
      <div class="entry-summary">
        {!! get_the_excerpt($last_post->ID); !!}
      </div>

      <div class="button-wrapper">
        @if ($terms_company)
          @foreach ($terms_company as $term)
            <a href="{{ get_term_link($term->term_id) }}" title="{!! $term->name !!}">
              <span class="post-badge">{!! $term->name !!}</span>
            </a>
          @endforeach
        @endif

        @if ($terms_products || $is_single_product)
          @foreach ($terms_products as $term)
            <a href="{{ get_term_link($term->term_id) }}" title="{!! $term->name !!}">
              <span class="post-badge">{!! $term->name !!}</span>
            </a>
          @endforeach
        @endif

        @if ($is_archive_products)
          <a href="{{ get_permalink($last_post->ID) }}" title="{!! get_the_title($last_post->ID) !!}" class="button-teaser-archive">
            <h5 class="show-product">{!! __('Vedi prodotto', 'thor') !!}</h5>
            <span>
              @svg('images/arrow-teaser-archive.svg')
            </span>
          </a>
        @endif

        @if ($is_archive_companies)
          <a href="{{ get_permalink($last_post->ID) }}" title="{!! get_the_title($last_post->ID) !!}" class="button-teaser-archive">
            <h5 class="show-product">{!! __('Vedi azienda', 'thor') !!}</h5>
            <span>
              @svg('images/arrow-teaser-archive.svg')
            </span>
          </a>
        @endif
      </div>
    </div>
  </div>
</article>