import Swiper from 'swiper';
// core version + navigation, pagination modules:
import SwiperCore, { Navigation, Pagination } from 'swiper/core';
// configure Swiper to use modules
SwiperCore.use([Navigation, Pagination]);

export default (() => {
  var swiper = new Swiper('.slider-home', {
    pagination: true,
    loop: false,
    navigation: {
      nextEl: '.custom-button-next',
      prevEl: '.custom-button-prev',
    },
    pagination: {
      el: '.swiper-pagination',
      clickable: true,
    },
    breakpoints: {
      768: {
        slidesPerView: 3,
        slidesPerGroup: 3,
        direction: 'horizontal',
      },
      1024: {
        slidesPerView: 4,
        slidesPerGroup: 4,
        direction: 'horizontal',
      },
    },
  });
})();

