@php
  $featured_home_post_ids = [];

  foreach ($featured_home_post as $post) {
    $featured_home_post_ids[] = $post->ID;
  };

  $args_last_posts = [
  'post_status' => 'publish',
  'posts_per_page' => 4,
  'orderby' => 'date',
  'category_name' => 'news',
  'post__not_in' => $featured_home_post_ids,
  ];
  $last_posts = get_posts($args_last_posts);
@endphp

<div class="last-news">
  <div>
    <div class="section-divider"></div>
    <h3 class="section-title">{!! __('Ultime News', 'thor') !!}</h3>
  </div>

  <div class="news-wrapper">
    @foreach ($last_posts as $last)
      @php
        $post_badge = get_field('lioit_post_badge_text', $last->ID);
        $term = get_the_terms( $last->ID, 'category' );
      @endphp
      <article class="post-teaser">
        <span class="post-badge">
          @if ($post_badge)
              {!! $post_badge !!}
          @else
            {!! $term[0]->name !!}
          @endif
          <time
            class="updated mobile"
            datetime="{{ get_post_time('d F o', true) }}">
            {{ get_the_date('d F o', $featured->ID) }}
          </time>
        </span>
        <header>
          <a href="{{ get_permalink($last->ID) }}" title="{!! get_the_title($last->ID) !!}">
            <h2>
              {!! get_the_title($last->ID) !!}
            </h2>
          </a>
        </header>
      </article>
    @endforeach
  </div>

  <div class="link-wrapper">
    <a class="link-archive" href="{!! get_category_link(  get_cat_ID('news') ) !!}">
      {!! __('Vedi tutte', 'thor') !!}
      @svg('images/arrow-right-archive.svg')
    </a>
  </div>
</div>