@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'thor-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'thor-'.$block['slug'];
  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $default_slides = array(
    array(
      'text'  => __('Insert first slide', 'thor'),
    ),
  );

  // Load values and assign defaults.
  $slides = get_field('slides') ?: $default_slides;

  $dots = get_field('dots') ?: false;
  $next_arrow = get_field('next_arrow');
  $before_arrow = get_field('before_arrow');
  $infinite = get_field('infinite') ?: false;
  $autoplay = get_field('autoplay') ?: false;
  //slick slide crashes with infinite on false and slide to show on 0
  $slides_to_show = (int) get_field('slides_to_show') ?: 1; //casting to prevent crash
  $arrows = get_field('arrows') ?: false;
  $slider_height = get_field('slider_height') ?: false;

  switch ($slides_to_show) {
    case 4:
      $slides_to_show_screen_lg = 3;
      $slides_to_show_screen_md = 2;
      $slides_to_show_screen_sm = 1;
      break;
    case 3:
      $slides_to_show_screen_lg = 3;
      $slides_to_show_screen_md = 2;
      $slides_to_show_screen_sm = 1;
      break;
    case 2:
      $slides_to_show_screen_lg = 2;
      $slides_to_show_screen_md = 1;
      $slides_to_show_screen_sm = 1;
      break;
    default:
      $slides_to_show_screen_lg = 1;
      $slides_to_show_screen_md = 1;
      $slides_to_show_screen_sm = 1;
    break;
  }

  $slick_options = array(
    'dots' => $dots,
    'infinite' => $infinite,
    'autoplay' => $autoplay,
    'arrows' => $arrows,
    'slidesToShow' => $slides_to_show,
    'prevArrow' => ".before-arrow",
    'nextArrow' => ".next-arrow",
    'responsive' => [
      array(
      'breakpoint' => 1024,
      'settings' => array(
        'slidesToShow' => $slides_to_show_screen_lg,
        'arrows' => false, 
        ),
      ),
      array(
      'breakpoint' => 870,
      'settings' => array(
        'slidesToShow' => $slides_to_show_screen_md,
        'arrows' => false, 
        ),
      ),
      array(
      'breakpoint' => 640,
      'settings' => array(
        'slidesToShow' => $slides_to_show_screen_sm,
        'arrows' => false,
        ),
      ),
    ],
  );


@endphp

<div id="{{ esc_attr($id) }}" class="{{ esc_attr($className) }}">
  @if ($slides)
    <button
      type="button"
      @if ($before_arrow)  
        style="background-image: url('{!! $before_arrow['url'] !!}')"
      @endif
      class="{{ !$before_arrow ?: 'image-arrow' }} slick-arrow before-arrow slick-prev"
    >
    </button>
    <button
      type="button"
      @if ($next_arrow)  
        style="background-image: url('{!! $next_arrow['url'] !!}')"
      @endif 
      class="{{ !$next_arrow ?: 'image-arrow' }} slick-arrow next-arrow slick-next"
    >
    </button>
    
    <div class="slider" data-slick="{!! esc_attr(json_encode($slick_options)) !!}">
      @foreach ($slides as $slide)
      @php
        $cta_invert = $slide['cta_invert'] ?: false;
        $btn_background_color = $slide['button_background_color'];
        $btn_text_color = $slide['button_text_color'];
      @endphp
      
        <div class="slide @if($slider_height) {!! $slider_height !!} @endif {!! $slide['text'] ? 'slide-has-text' : 'slide-no-text' !!}">

            <figure 
                class="@if($slider_height) {!! $slider_height !!} @endif" 
                style="@if($slides_to_show > 1) margin: 0 5px; @endif background-color: @if($slide['background_color']) {!! $slide['background_color'] !!} @endif">

              @if ($slide['image'])
                <img style="opacity: @if($slide['background_opacity']) {!! $slide['background_opacity'] !!} @endif" 
                     src="{!! $slide['image']['sizes']['full_hd'] !!}" />
              @endif

            </figure>

            <div class="slider-content mt-1" style="text-align: {!! $slide['align'] !!}"> 
                {!! $slide['text'] !!}
                @if($slide['cta'])
                <a 
                  class="btn mt-6 text-xl font-semibold px-10 @if($cta_invert) invert @endif" 
                  style="color: {!! $btn_text_color !!} !important;
                     @if(!($cta_invert)) background-color:{!! $btn_background_color !!}; @endif
                     @if($cta_invert) border: 1px solid {!! $btn_background_color !!}; @endif"
                  href="{{ $slide['cta']['url'] }}" target="{{ $slide['cta']['target'] }}" 
                  title="{{ $slide['link']['title'] }}">
                    {{ $slide['cta']['title'] }}
                </a>
                @endif
            </div>
        </div>
      @endforeach
    </div>
  @endif
</div>