@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'thor-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'thor-'.$block['slug'];
  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $markers = get_field('markers');
@endphp

@if($markers)
  <div id="{{ esc_attr($id) }}" class="{{ esc_attr($className) }}" itemscope itemtype="http://schema.org/Place">
    <div class="map" id="map-{!! $id !!}" itemprop="geo" itemscope itemtype="http://schema.org/GeoCoordinates">
      @foreach($markers as $mark)
      @php
        $icon = $mark['icon'];
        $address = $mark['address'];
        $geo_position = $mark['geo_position'];
      @endphp
      <div class="marker"
        itemprop="latitude" content="{!! $geo_position['lat'] !!}"
        itemprop="longitude" content="{!! $geo_position['lng'] !!}"
        data-icon="{!! $icon['url'] !!}"
        data-lat="{!! $geo_position['lat'] !!}"
        data-lng="{!! $geo_position['lng'] !!}">
        @if($address) {!! $address !!} @endif
      </div><!--marker-->
      @endforeach
    </div>
  </div>
@endif