@php
  $args_tickers_posts = [
    'post_type' => 'post',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'meta_query' => [
      [
        'key'   => 'view_on_ticker',
        'value' => true,
        'compare' => 'LIKE',
      ],
    ],
  ];
  $tickers_posts = get_posts($args_tickers_posts);
@endphp

<div class="ticker" id="ticker">
  <div class="badge">
    <span>●</span>
    <h4>{!! __('Ultime news', 'thor') !!}</h4>
  </div>

  <div class="ticker-wrap" id="ticker-wrap">
    @if ($tickers_posts)
      @foreach($tickers_posts as $item)
        @php
          $post_badge = get_field('lioit_post_badge_text', $item->ID);
        @endphp
        <a href="{{ get_permalink($item) }}" title="{!! get_the_title($item) !!}">
            <span>{!! $post_badge !!}</span>
            {!! get_the_title($item) !!}
        </a>
      @endforeach
    @endif
  </div>
</div>