@php
  $term = get_the_terms( get_the_ID(), 'category' );
  $post_badge = get_field('lioit_post_badge_text', get_the_ID());

  $args_related = [
  'post__not_in' => [get_the_ID()],
  'post_status' => 'publish',
  'posts_per_page' => 3,
  'category_name' => $term[0]->slug,
  ];
  $related = get_posts($args_related);
@endphp

<div class="related">
  <div class="related-inner">
    <div class="section-header">
      <div class="section-divider"></div>
      <div class="flex justify-between">
        @if ($tags[0]->slug != 'tgie')
          <h3 class="section-title">{!! __('articoli correlati', 'thor') !!}</h3>
        @endif
        @if ($tags[0]->slug == 'tgie')
          <h3 class="section-title">{!! __('TGIE Correlati', 'thor') !!}</h3>  
        @endif
        @if ($tags[0]->slug != 'tgie')
          <a class="link-archive" href="{!! get_category_link(  get_cat_ID($term[0]->slug) ) !!}">
            {!! __('Vedi tutte', 'thor') !!}
            @svg('images/arrow-right-archive.svg')
          </a>
        @endif
        @if ($tags[0]->slug == 'tgie')
          <a class="link-archive" href="{!! get_category_link(  get_cat_ID('tgie') ) !!}">
            {!! __('Vedi tutte', 'thor') !!}
            @svg('images/arrow-right-archive.svg')
          </a>
        @endif
      </div>
    </div>
    <div class="teaser-wrapper">
      @if ($term)
        @foreach ($related as $post_related)
          <article class="post-teaser">
            <span class="post-badge">
              {!! $post_badge !!}
              <time
                class="updated mobile"
                datetime="{{ get_post_time('d F o', true) }}">
                {{ get_the_date('d F o', $featured->ID) }}
              </time>
            </span>

            <div class="content-wrapper">
              @if (has_post_thumbnail($slide->ID))
                <figure>
                  <a href="{{ get_permalink($post_related->ID) }}" title="{!! get_the_title($post_related->ID) !!}">
                    <img
                      class="lazy"
                      src="{!! get_the_post_thumbnail_url($post_related->ID, 'mini') !!}"
                      data-src="{!! get_the_post_thumbnail_url($post_related->ID, 'large') !!}"
                    />
                  </a>
                </figure>
              @endif

              <header>
                <a href="{{ get_permalink($post_related->ID) }}" title="{!! get_the_title($post_related->ID) !!}">
                  <h2>
                    {!! get_the_title($post_related->ID) !!}
                  </h2>
                </a>
              </header>
            </div>

            <time
              class="updated"
              datetime="{{ get_post_time('d F o', true) }}">
              {{ get_the_date('d F o', $post_related->ID) }}
            </time>
          </article>
        @endforeach
      @endif
    </div>

    <div class="link-wrapper">
      <a class="link-archive" href="#">
        {!! __('Vedi tutte', 'thor') !!}
        @svg('images/arrow-right-archive.svg')
      </a>
    </div>
  </div>
  <div class="adv-wrapper">
    @include('partials.adv-halfpage')
  </div>
</div>