@php
  $term = get_the_terms( get_the_ID(), 'category' );
  $is_post_type_archive = is_post_type_archive();
  $post_type_name = get_post_type();
  $post_badge = get_field('lioit_post_badge_text', get_the_ID());
@endphp

<div class="page-header">
  <div class="post-info">
    <div class="post-category">
      @if ($post_badge)
        {!! $post_badge !!}
      @else
        {!! $term[0]->name !!}
      @endif
    </div>
    <time>{{ get_the_date() }}</time>
  </div>
  <div class="section-divider"></div>
  <div class="container @if($is_post_type_archive) header-cpt-archive @endif">
    <h1>{!! App::title() !!}</h1>
    @if ($post_subtitle)
      <div class="subtitle">{!! $post_subtitle !!}</div>
    @endif

    @if(function_exists('is_shop') && is_shop())
      <div class="shop-archive-ordering">
        @php
          do_action('woocommerce_before_shop_loop');
          woocommerce_product_loop_start();
        @endphp
      </div>
    @endif

    @if($is_post_type_archive)
      @if($post_type_name == 'companies' || $post_type_name == 'products')
        <div class="button-filter-form">
          {!!  __('Tutti i filtri', 'thor') !!}
          @svg('images/filter-icon.svg')
        </div>
      @endif
    @endif

    @if($is_post_type_archive)
        @if($post_type_name == 'companies')
          <form class="filter-form desktop" method="GET" action="{!! get_post_type_archive_link( 'companies' ) !!}">
            <label for="companies-category">
              <select name="category-companies" id="category_companies" onchange="this.form.submit()">
                <option value="">{!!  __('Tutte le categorie', 'thor') !!}</option>
                @foreach ($terms as $term)
                  @php
                      $queried = $_GET['category-companies'];
                  @endphp
                  @if($queried == $term->slug)
                    <option selected value="{!! $term->slug !!}">
                      {!! $term->name !!}
                    </option>
                  @else
                    <option value="{!! $term->slug !!}">
                        {!! $term->name !!}
                    </option>
                  @endif
                @endforeach
              </select>
            </label>

            <label for="">
              @php
                  $queried = $_GET['title-order'];
              @endphp
              <select name="title-order" id="title-order" onchange="this.form.submit()">
                @if($queried == 'ASC')
                  <option selected value="ASC">{!!  __('A - Z', 'thor') !!}</option>
                  <option value="DESC">{!!  __('Z - A', 'thor') !!}</option>
                @elseif($queried == 'DESC')
                  <option value="ASC">{!!  __('A - Z', 'thor') !!}</option>
                  <option selected value="DESC">{!!  __('Z - A', 'thor') !!}</option>
                @else
                  <option value="ASC">{!!  __('A - Z', 'thor') !!}</option>
                  <option value="DESC">{!!  __('Z - A', 'thor') !!}</option>
                @endif
              </select>
            </label>


            <input class="filter" id="submit" type="submit" value="{!! __('Applica','thor') !!}"/>

            <a class="reset-filters" href="{!! get_post_type_archive_link( 'companies' ) !!}"><span>{!! __('Reset','thor') !!}</span></a>
          </form>

        @elseif($post_type_name == 'products')
          <form class="filter-form desktop" method="GET" action="{!! get_post_type_archive_link( 'products' ) !!}">
            <label for="">
              <select name="category-product" id="category" onchange="this.form.submit()">
                <option value="">{!!  __('Tutte le categorie', 'thor') !!}</option>
                @foreach ($terms as $term)
                  @php
                      $queried = $_GET['category-product'];
                  @endphp
                  @if($queried == $term->slug)
                    <option selected value="{!! $term->slug !!}">
                      {!! $term->name !!}
                    </option>
                  @else
                    <option value="{!! $term->slug !!}">
                        {!! $term->name !!}
                    </option>
                  @endif
                @endforeach
              </select>
            </label>

            <label for="">
              <select name="company" id="companies" onchange="this.form.submit()">
                <option value="">{!!  __('Tutte le aziende', 'thor') !!}</option>
                @foreach ($companies as $company)
                  @php
                      $queried = $_GET['company'];
                  @endphp
                  @if($queried == $company->ID)
                    <option selected value="{!! $company->ID !!}">
                      {!! $company->post_title !!}
                    </option>
                  @else
                    <option value="{!! $company->ID !!}">
                        {!! $company->post_title !!}
                    </option>
                  @endif
                @endforeach
              </select>
            </label>

            <label for="">
              @php
                  $queried = $_GET['date-order'];
              @endphp
              <select name="date-order" id="date-order" onchange="this.form.submit()">
                @if($queried == 'DESC')
                  <option selected value="DESC">{!!  __('Dal più recente', 'thor') !!}</option>
                  <option value="ASC">{!!  __('Dal meno recente', 'thor') !!}</option>
                @elseif($queried == 'ASC')
                  <option value="DESC">{!!  __('Dal più recente', 'thor') !!}</option>
                  <option selected value="ASC">{!!  __('Dal meno recente', 'thor') !!}</option>
                @else
                  <option value="DESC">{!!  __('Dal più recente', 'thor') !!}</option>
                  <option value="ASC">{!!  __('Dal meno recente', 'thor') !!}</option>
                @endif
              </select>
            </label>


            <input class="filter" id="submit" type="submit" value="{!! __('Applica','thor') !!}"/>

            <a class="reset-filters" href="{!! get_post_type_archive_link( 'products' ) !!}"><span>{!! __('Reset','thor') !!}</span></a>
          </form>
        @endif
    @endif
  </div><!--container-->
</div><!--page-headrr-->

@if($is_post_type_archive)
    @if($post_type_name == 'companies')
      <form class="filter-form mobile" method="GET" action="{!! get_post_type_archive_link( 'companies' ) !!}">
        <label for="companies-category">
          <select name="category-companies" id="category_companies" onchange="this.form.submit()">
            <option value="">{!!  __('Tutte le categorie', 'thor') !!}</option>
            @foreach ($terms as $term)
              @php
                  $queried = $_GET['category-companies'];
              @endphp
              @if($queried == $term->slug)
                <option selected value="{!! $term->slug !!}">
                  {!! $term->name !!}
                </option>
              @else
                <option value="{!! $term->slug !!}">
                    {!! $term->name !!}
                </option>
              @endif
            @endforeach
          </select>
        </label>

        <label for="">
          @php
              $queried = $_GET['title-order'];
          @endphp
          <select name="title-order" id="title-order" onchange="this.form.submit()">
            @if($queried == 'ASC')
              <option selected value="ASC">{!!  __('A - Z', 'thor') !!}</option>
              <option value="DESC">{!!  __('Z - A', 'thor') !!}</option>
            @elseif($queried == 'DESC')
              <option value="ASC">{!!  __('A - Z', 'thor') !!}</option>
              <option selected value="DESC">{!!  __('Z - A', 'thor') !!}</option>
            @else
              <option value="ASC">{!!  __('A - Z', 'thor') !!}</option>
              <option value="DESC">{!!  __('Z - A', 'thor') !!}</option>
            @endif
          </select>
        </label>


        <input class="filter" id="submit" type="submit" value="{!! __('Applica','thor') !!}"/>

        <a class="reset-filters" href="{!! get_post_type_archive_link( 'companies' ) !!}"><span>{!! __('Reset','thor') !!}</span></a>
      </form>

    @elseif($post_type_name == 'products')
      <form class="filter-form mobile" method="GET" action="{!! get_post_type_archive_link( 'products' ) !!}">
        <label for="">
          <select name="category-product" id="category" onchange="this.form.submit()">
            <option value="">{!!  __('Tutte le categorie', 'thor') !!}</option>
            @foreach ($terms as $term)
              @php
                  $queried = $_GET['category-product'];
              @endphp
              @if($queried == $term->slug)
                <option selected value="{!! $term->slug !!}">
                  {!! $term->name !!}
                </option>
              @else
                <option value="{!! $term->slug !!}">
                    {!! $term->name !!}
                </option>
              @endif
            @endforeach
          </select>
        </label>

        <label for="">
          <select name="company" id="companies" onchange="this.form.submit()">
            <option value="">{!!  __('Tutte le aziende', 'thor') !!}</option>
            @foreach ($companies as $company)
              @php
                  $queried = $_GET['company'];
              @endphp
              @if($queried == $company->ID)
                <option selected value="{!! $company->ID !!}">
                  {!! $company->post_title !!}
                </option>
              @else
                <option value="{!! $company->ID !!}">
                    {!! $company->post_title !!}
                </option>
              @endif
            @endforeach
          </select>
        </label>

        <label for="">
          @php
              $queried = $_GET['date-order'];
          @endphp
          <select name="date-order" id="date-order" onchange="this.form.submit()">
            @if($queried == 'DESC')
              <option selected value="DESC">{!!  __('Dal più recente', 'thor') !!}</option>
              <option value="ASC">{!!  __('Dal meno recente', 'thor') !!}</option>
            @elseif($queried == 'ASC')
              <option value="DESC">{!!  __('Dal più recente', 'thor') !!}</option>
              <option selected value="ASC">{!!  __('Dal meno recente', 'thor') !!}</option>
            @else
              <option value="DESC">{!!  __('Dal più recente', 'thor') !!}</option>
              <option value="ASC">{!!  __('Dal meno recente', 'thor') !!}</option>
            @endif
          </select>
        </label>


        <input class="filter" id="submit" type="submit" value="{!! __('Applica','thor') !!}"/>

        <a class="reset-filters" href="{!! get_post_type_archive_link( 'products' ) !!}"><span>{!! __('Reset','thor') !!}</span></a>
      </form>
    @endif
@endif
