@php
  $post_subtitle = get_field('post_subtitle');
  $tags = get_the_tags( get_the_ID() );
  $format = get_post_format(get_the_ID());
  $video = get_field('embed_video');
@endphp

<article {!! post_class('single-post-wrapper') !!}>

  @include('partials/page-header')

  <div class="container">

    <div class="single-post-inner clearfix">
      <div class="post-content-wrapper">
        <div class="content">
          @if($format != 'video')
            <figure class="main-image">
              <img
                class="lazy"
                src="{!! get_the_post_thumbnail_url(get_the_ID(), 'thumbnail') !!}"

                data-src="{!! get_the_post_thumbnail_url(get_the_ID(), 'large') !!}"

              />
            </figure>
          @endif

          @if ($format == 'video')
            <div class="video-iframe">
              {!! $video !!}
            </div>
          @endif
          @php the_content() @endphp

          <div class="social-wrapper">
            <div class="share">
              <h5>
                {!! __('Condividi', 'thor') !!}
              </h5>
              <button class="button-social" data-sharer="facebook" data-url="{!! get_permalink() !!}">
                @svg('images/social/svg/facebook-dark.svg')
              </button>
              <button class="button-social" data-sharer="whatsapp" data-url="{!! get_permalink() !!}">
                @svg('images/social/svg/whatsapp.svg')
              </button>
               <button class="button-social" data-sharer="twitter" data-url="{!! get_permalink() !!}">
                @svg('images/social/svg/twitter-dark.svg')
              </button>
               <button class="button-social" data-sharer="linkedin" data-url="{!! get_permalink() !!}">
                @svg('images/social/svg/linkedin.svg')
              </button>
            </div><!--share-->

            @if ($tags)
              <div class="tags-wrapper">
                <h5>
                  {!! __('TAG', 'thor') !!}
                </h5>
                @foreach ($tags as $tag)
                  <a href="{!! get_tag_link($tag->term_id) !!}">
                    {!! $tag->name !!}
                  </a>
                @endforeach
              </div>
            @endif
          </div>

        </div>

        <div class="right-content-wrapper">
          <div class="adv-wrapper">
            @include('partials.adv-box')
            @include('partials.adv-box')
            @include('partials.adv-box')
          </div>

          @include('partials.more-news-aside')
        </div>
      </div>

      @include('partials.related')
      
    </div><!--single-post-inner-->
  </div><!--container-->
</article>
