@php
  $terms = get_terms('category_products', array (
    'hide_empty' => false,
  ));

  $args_companies = [
    'post_type' => 'companies',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'orderby' => 'title',
    'order' => 'ASC',
  ];
  $companies = get_posts($args_companies);

  $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

  $count_posts = $GLOBALS['wp_query']->post_count;
@endphp
@extends('layouts.app')

@section('content')
  @include('partials.page-header')

  <div class="container">
    @if (!have_posts())
      <div class="alert alert-warning">
        {{ __('Sorry, no results were found.', 'thor') }}
      </div>
      {!! get_search_form(false) !!}
    @else

      @if ($paged == 1 && $count_posts > 3)
        <div class="big-posts-wrapper">
          <div class="post-wrapper">
            @php the_post() @endphp
            @if (have_posts())
                @include('partials.teaser-posts-category')
              @endif
          </div>
          <div class="post-wrapper">
            @php the_post() @endphp
            @if (have_posts())
                @include('partials.teaser-posts-category')
              @endif
          </div>
          <div class="post-wrapper">
            @php the_post() @endphp
            @if (have_posts())
                @include('partials.teaser-posts-category')
              @endif
          </div>
          <div class="post-wrapper">
            @php the_post() @endphp
            @if (have_posts())
                @include('partials.teaser-posts-category')
              @endif
          </div>
        </div>
      @endif

      <div class="content-wrapper archive">
        <div class="posts-wrapper">
          @while (have_posts())
            @php the_post() @endphp
              @include('partials.teaser-posts-category')
          @endwhile
        </div>

        <div class="adv-wrapper">
          @include('partials.adv-box')
          @include('partials.adv-box')
          @include('partials.adv-box')
          @include('partials.adv-halfpage')
        </div>
      </div>
    @endif

    @if(function_exists('wp_pagenavi'))
      {!!  wp_pagenavi(); !!}
    @endif

  </div><!--container-->
@endsection
